
function temp_x = select_reproduce(x,mu,lu,n,gen,threshold_gen,total_gen)

% Parameter settings
F = 0.8;
CR = 0.9;
pm = 0.05;

% Initialize the set 'temp_x'
temp_x = zeros(mu * 3, n);

% Evolve all the parent individuals
for i = 1:mu 
    %% "rand/1" strategy
    
    nouse_ = 1:mu;
    nouse_(i) = [];

    temp = floor(rand * (mu - 1)) + 1;
    nouse(1) = nouse_(temp);
    nouse_(temp) = [];

    temp = floor(rand * (mu - 2)) + 1;
    nouse(2) = nouse_(temp);
    nouse_(temp) = [];

    temp = floor(rand * (mu - 3)) + 1;
    nouse(3) = nouse_(temp);

    % Mutation
    v1 = x(nouse(1),:) + F .* (x(nouse(2),:) - x(nouse(3),:));

    % Boundary constraint check
    w = find(v1 < lu(1,:));
    if ~isempty(w)
        v1(1,w) = 2 .* lu(1,w) - v1(1,w);
        w1 = find(v1(1,w) > lu(2,w));
        if ~isempty(w1)
            v1(1,w(w1)) = lu(2,w(w1));
        end
    end
    y = find(v1 > lu(2,:));
    if ~isempty(y)
        v1(1,y) = 2 .* lu(2,y) - v1(1,y);
        y1 = find(v1(1,y) < lu(1,y));
        if ~isempty(y1)
            v1(1,y(y1)) = lu(1,y(y1));
        end
    end

    % Crossover
    j_rand = floor(rand * n)+1;
    t = rand(1,n) < CR;
    t(1,j_rand) = 1;
    t_ = 1 - t;
    % Obtain the first offspring individual
    u1 = t .* v1 + t_ .* x(i,:);

    %% "current to rand/1" & 'current to best/1 'strategy
    
    nouse_ = 1:mu;
    nouse_(i) = [];

    temp = floor(rand * (mu-1)) + 1;
    nouse(1) = nouse_(temp);
    nouse_(temp) = [];

    temp = floor(rand * (mu-2)) + 1;
    nouse(2) = nouse_(temp);
    nouse_(temp) = [];

    temp = floor(rand * (mu-3)) + 1;
    nouse(3) = nouse_(temp);
    
    % Mutation
    if gen <= threshold_gen
        v3 = x(i,:) + rand * (x(nouse(3),:) - x(i,:)) + F .* (x(nouse(1),:) - x(nouse(2),:));
    else
        v3 = x(i,:) + F * (x(1,:) - x(i,:)) + F .* (x(nouse(1),:) - x(nouse(2),:));
    end

    % Boundary constraint check
    w = find(v3 < lu(1,:));
    if ~isempty(w)
        v3(1,w) = 2 .* lu(1,w) - v3(1,w);
        w1 = find(v3(1,w) > lu(2,w));
        if ~isempty(w1)
            v3(1,w(w1)) = lu(2,w(w1));
        end
    end
    y = find(v3 > lu(2,:));
    if ~isempty(y)
        v3(1,y) = 2 .* lu(2,y) - v3(1,y);
        y1 = find(v3(1,y) < lu(1,y));
        if ~isempty(y1)
            v3(1,y(y1)) = lu(1,y(y1));
        end
    end

    % Obtain the second offspring individual and do IBGA operation
    u3 = v3;
    if rand < pm
        temp = floor(rand * n) + 1;
        mutrange = (lu(2,temp) - lu(1,temp)) * (1 - gen / total_gen)^6;
        if rand < 0.5
            sign_ = 1;
        else
            sign_ = -1;
        end
        u3(1,temp) = u3(1,temp) + mutrange * sign_ * 2^(-round(rand * 15));
        if u3(1,temp) > lu(2,temp)
            u3(1,temp) = lu(2,temp);
        elseif u3(1,temp) < lu(1,temp)
            u3(1,temp) = lu(1,temp);
        end
    end
        
    %% "rand/2" strategy
    
    nouse_ = 1:mu;
    nouse_(i) = [];

    temp = floor(rand * (mu-1)) + 1;
    nouse(1) = nouse_(temp);
    nouse_(temp) = [];

    temp = floor(rand * (mu-2)) + 1;
    nouse(2) = nouse_(temp);
    nouse_(temp) = [];

    temp = floor(rand * (mu - 3)) + 1;
    nouse(3) = nouse_(temp);
    nouse_(temp) = [];

    temp = floor(rand * (mu - 4)) + 1;
    nouse(4) = nouse_(temp);
    nouse_(temp) = [];

    temp = floor(rand * (mu - 5)) + 1;
    nouse(5) = nouse_(temp);

    % Mutation
    v5 = x(nouse(1),:) + F .* (x(nouse(2),:) - x(nouse(3),:)) + F .* (x(nouse(4),:) - x(nouse(5),:));

    % Boundary constraint check
    w = find(v5 < lu(1,:));
    if ~isempty(w)
        v5(1,w) = 2 .* lu(1,w) - v5(1,w);
        w1 = find(v5(1,w) > lu(2,w));
        if ~isempty(w1)
            v5(1,w(w1)) = lu(2,w(w1));
        end
    end
    y = find(v5 > lu(2,:));
    if ~isempty(y)
        v5(1,y) = 2 .* lu(2,y) - v5(1,y);
        y1 = find(v5(1,y) < lu(1,y));
        if ~isempty(y1)
            v5(1,y(y1)) = lu(1,y(y1));
        end
    end
    
    % Crossover
    j_rand = floor(rand * n) + 1;
    t = rand(1,n) < CR;
    t(1,j_rand) = 1;
    t_ = 1 - t;
    
    % Obtain the third offspring individual
    u5 = t .* v5 + t_ .* x(i,:);

    %% Save the three individual to temp_x
    temp_x(3 * i - 2:3 * i,:) = [u1;u3;u5];
    
end